<?php

global $th_pre; // theme prefix for get option
global $th_messages;	// for handling messages

$th_pre	= "reviewsite_";

// defining file folder

	define(ADMINFUNC	,STYLESHEETPATH.'/admin/');
	define(THEMEFUNC	,STYLESHEETPATH.'/functions/');
	define(PLUGINSFUNC	,STYLESHEETPATH.'/plugins/');
	define(WIDGETFUNC	,STYLESHEETPATH.'/widgets/');
	define(SCRIPTFUNC	,STYLESHEETPATH.'/scripts/');
	
// defining link

	define(THEMELINK	,get_bloginfo("stylesheet_directory"));
	
// including file system
	include(ADMINFUNC.'index.php');
	include(ADMINFUNC.'setting.php');
	include(ADMINFUNC.'metabox.php');
	include(ADMINFUNC.'layout-app.php');
	include(ADMINFUNC.'layout.php');
	include(ADMINFUNC.'rating.php');
	include(ADMINFUNC.'top-rating.php');
	
// including built-in function file
	include(THEMEFUNC.'menu.php');

// embedding with internal plugins
	include(PLUGINSFUNC.'limit-post.php');
	include(PLUGINSFUNC.'breadcrumbs.php');
	include(PLUGINSFUNC.'exit-popup/exit-popup.php');
	include(PLUGINSFUNC.'linkcloaker/linkcloaker.php');
	
// embedding with external scripts
	
// theme support
	add_theme_support('post-thumbnails');
	set_post_thumbnail_size(700,310);
	add_image_size( 'single-post-thumbnail'		, 217, 207,true );
	add_image_size( 'sidebar-post-thumbnail'	, 125, 105,true );

// calling any action
	add_action('init'				,'reviewSiteThemeInit');
	add_action('admin_head'			,'reviewSiteAdminHead');
	add_action('admin_footer'		,'reviewSiteAdminFooter');
	add_action('wp_footer'			,'reviewSiteFooter');
	add_action('wp_print_scripts'	,'reviewSiteRegisterScript');
	add_action('wp_print_styles'	,'reviewSiteRegisterCSS');
	add_action("admin_print_scripts","reviewSiteAdminRegisterScript");
	add_action("admin_print_styles"	,"reviewSiteAdminRegisterCSS");
	add_action('after_setup_theme'	,'reviewSiteRegisterMenu');
	add_action ('comment_post'		,'reviewSiteCommentPost');
	
	function reviewSiteCommentPost($comment_id) {
		add_comment_meta($comment_id, 'commentrating', $_POST['commentrating'], true);
	}

	
// calling any filter
	add_filter('body_class'		,'reviewSiteBodyClass');
	
// calling init theme
	function reviewSiteThemeInit()
	{
		// for registering sidebar
		$args = array(
			'name'          => "Sidebar",
			'id'            => 'sidebar-home',
			'description'   => '',
			'before_widget' => '<div class="widget">',
			'before_title'  => 		'<h1 class="widget-title">',
			'after_title'   => 		'</h1>'.
									'<div class="widget-content">',
			'after_widget'  => 		'</div>'.
							   '</div>',
		);
		
		register_sidebar($args);

	}
	
// built-in functions

	// for registering menu
	function reviewSiteRegisterMenu()
	{
		register_nav_menu("top-menu","Top Menu"); 
		register_nav_menu("footer-menu","Footer Menu"); 
	}
	
	// register javascript link
	function reviewSiteRegisterScript()
	{
		wp_register_script('superfish',				get_bloginfo('template_url').'/js/superfish.js',array('jquery'));
		wp_register_script('jquery.pikachoose',		get_bloginfo('template_url').'/js/jquery.pikachoose.js',array('jquery'));
		wp_register_script('jquery.jcarousel',		get_bloginfo('template_url').'/js/jquery.jcarousel.js',array('jquery'));
		wp_register_script('jquery.curvycorner',	get_bloginfo('template_url').'/js/jquery.curvycorners.js',array('jquery'));
		wp_register_script('custom-script',			get_bloginfo('template_url').'/js/custom-script.js',array('jquery'));
		wp_register_script('jquery.rating',			get_bloginfo('template_url').'/js/jquery.rating.js',array('jquery'));

		wp_enqueue_script('jquery');
		wp_enqueue_script('superfish');
		wp_enqueue_script('jquery.pikachoose');
		wp_enqueue_script('jquery.jcarousel');
		wp_enqueue_script('jquery.curvycorner');
		wp_enqueue_script('custom-script');		
		wp_enqueue_script('jquery.rating');				
	}
	
	// register css link
	function reviewSiteRegisterCSS()
	{
		wp_register_style('superfish',		get_bloginfo('template_url').'/css/superfish.css');
		wp_register_style('custom-style',	get_bloginfo('template_url').'/style.php');
		wp_register_style('jquery.rating',	get_bloginfo('template_url').'/css/jquery.rating.css');
		
		wp_enqueue_style('superfish');
		wp_enqueue_style('custom-style');
		wp_enqueue_style('jquery.rating');
	}
	
	// register admin javascript link
	function reviewSiteAdminRegisterScript()
	{
		wp_register_script('jpicker'		, THEMELINK.'/admin/js/jpicker.js',array('jquery'));
		wp_register_script('tinymce'		, THEMELINK.'/admin/js/tiny_mce/tiny_mce.js');
		wp_register_script('colorpicker'	, THEMELINK.'/admin/js/colorpicker.js');
		wp_register_script('my-upload'		, THEMELINK.'/admin/js/script.php?upload=8', array('jquery','media-upload','thickbox'));
		
		wp_enqueue_script('jquery');
		wp_enqueue_script('tinymce');
		wp_enqueue_script('media-upload');
		wp_enqueue_script('thickbox');
		wp_enqueue_script('my-upload');
		wp_enqueue_script('jpicker');
	}
	
	// calling action for admin_head hook
	function reviewSiteAdminHead()
	{
		?>
        <script type="text/javascript" language="javascript1.2" src="<?php echo THEMELINK; ?>/admin/js/script.php?upload=10"></script>
        <?php
	}
	
	// calling action for admin_footer hook
	function reviewSiteAdminFooter()
	{

	}
	
	// register admin css link
	function reviewSiteAdminRegisterCSS()
	{
		wp_register_style('jpicker'			, THEMELINK.'/admin/css/jPicker.css');
		wp_register_style('jpicker-sub'		, THEMELINK.'/admin/css/jPicker-sub.css');
		
		wp_enqueue_style('jpicker');
		wp_enqueue_style('jpicker-sub');
	}
	
	// calling any function on footer
	function reviewSiteFooter()
	{

	}
		
	/* body_class filtering */
	function reviewSiteBodyClass($classes,$class = null)
	{
		global $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;
	
		if(is_search() || is_single() || is_page || is_category() || is_tag()) :
			$classes[]	= "not-front";
		endif;
		
		if($is_lynx) 		$classes[] = 'lynx';
		elseif($is_gecko) 	$classes[] = 'gecko';
		elseif($is_opera) 	$classes[] = 'opera';
		elseif($is_NS4) 	$classes[] = 'ns4';
		elseif($is_safari) 	$classes[] = 'safari';
		elseif($is_chrome) 	$classes[] = 'chrome';
		elseif($is_IE) 		$classes[] = 'ie';
		else $classes[] = 'unknown';

		if($is_iphone) $classes[] = 'iphone';

		
		return $classes;
	}
	
	function reviewSiteGetOption($name,$type = 'text',$caption = null)
	{
		global $th_pre;
		
		$value	= stripslashes(get_option($th_pre.$name));
		
		if(!empty($value)) :
			switch($type) :
			
				case "image"	: return "<img src='".$value."' title='".$caption."' />"; 
								  break;
				
				case "page"		: $page	= get_page($value);
								  return $page;
								  break;
								  
				case "text"		: return $value; 
								  break;
				
			endswitch;
		endif;
		
		return '';
	}
	
	function reviewSiteCustomPost($name,$postID)
	{
		$value	= get_post_custom_values($name,$postID);
		return (sizeof($value) > 0) ? end($value) : NULL;
	}
	
	function reviewSiteComment( $comment, $args, $depth ) 
	{
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case '' :
		?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<div id="comment-<?php comment_ID(); ?>">
			<div class="comment-author vcard">
				<?php echo get_avatar( $comment, 40 ); ?>
				<?php printf( __( '%s <span class="says">says:</span>', 'twentyten' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
			</div><!-- .comment-author .vcard -->
			<?php if ( $comment->comment_approved == '0' ) : ?>
				<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'twentyten' ); ?></em>
				<br />
			<?php endif; ?>
	
			<div class="comment-meta commentmetadata"><a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
				<?php
					/* translators: 1: date, 2: time */
					printf( __( '%1$s at %2$s', 'twentyten' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'twentyten' ), ' ' );
				?>
			</div><!-- .comment-meta .commentmetadata -->
	
			<div class="comment-body"><?php comment_text(); ?></div>
            
            <?php 
				$rating	= get_comment_meta(get_comment_ID(),"commentrating");
				
				if(sizeof($rating) > 0) :
				$rating	= end($rating);
				?>
        	    <div class="comment-rating">
				<?php
					for($i = 1;$i <= $rating;$i++) :
					?><img src="<?php bloginfo('template_url'); ?>/images/icon-star-mini.png" alt="" /><?php
					endfor;
				?>
	            </div>
    	        <?php 
					endif; 
			?>
	
			<div class="reply">
				<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
			</div><!-- .reply -->
		</div><!-- #comment-##  -->
	
		<?php
				break;
			case 'pingback'  :
			case 'trackback' :
		?>
		<li class="post pingback">
			<p><?php _e( 'Pingback:', 'twentyten' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'twentyten' ), ' ' ); ?></p>
		<?php
				break;
		endswitch;
	}
	
	function reviewSiteTopRating()
	{
		global $reviewsite_toprating;
		
		$reviewsite_toprating->front();
	}

	function reviewSiteDebug($value)
	{
		?><pre><?php
		print_r($value);
		?></pre><?php
	}
	
?>